
  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Sun Feb 20 12:09:37 2005
   *  Last modified   :  %modify_time%
   */
  /** @file 
   *  \brief A brief description of this module 
   *
   *  \version CRYS_Ext_ATP_DH_Acceptance.c#1:csrc:1
   *  \author doronp
   *  \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
   *           All Rights reserved
   */



/***** Include Files ***********/ 
#include "CRYS.h"
 
#include "CRYS_RSA_Types.h" 
#include "CRYS_DH.h"

#include "CRYS_Ext_ATP_TST_Defines.h"
#include "CRYS_Ext_ATP_DH_Acceptance_test_vectors.h"
#include "CRYS_ATP_TST_Defines.h"
#include "CRYS_ATP_TST_UTIL_Funcs.h"

#include "DX_VOS_Mem.h"

/******** Defines ********/ 
/******** Enums **********/ 
/******** Typedefs *********/ 
/******** Global Data ********/ 


extern DxUint8_t FailureFunctionNameOut[FailureFunctionName_K_Size];


/***** Private function prototype ******/ 
/******** Public Functions *****/ 
/***************************
 * Function Name:                                                           
 *  CRYS_Ext_ATP_DH_Acceptance_PKCS3        
 *  
 * Inputs:
 *  None
 *
 * Outputs: 
 *  CRYSError_t - Function error return                                     
 *
 * Description:  
 *  This function Is a Acceptance test for the Diffie-Hellman key agreement 
 *  scheme according to PKCS#3  
 *  Prime sizes used (in bits) - 2048                                  
 *  Generator sizes used (in bits) - 2048
 *  L sizes used - 12 
 *
 * Algorithm:       
 * 1. Call the SEPQA_DH_PKCS3 function to execute test
 * 2. Verify function succeded according to the returned error code
 *
 **************************/
CRYSError_t CRYS_Ext_ATP_DH_Acceptance_PKCS3(void)
{
    int          TST_Index = 0; 
    CRYSError_t  TST_TestStatus=0;
    char         TST_MasterTestName[TST_FUNC_STRING_LEN] = "CRYS_Ext_ATP_DH_Acceptance_PKCS3";
    
    ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"********************* \n"));
    ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"** CRYS_Ext_ATP_DH_Acceptance_PKCS3 Tests ******* \n"));        
    ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"********************* \n \n")); 

    /****************/
    /***** Start of test ********/
    /****************/  
	ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"************************ \n")); 
    ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"   %s [test 1.%d] \n",SEP_DH_Acceptance_PKCS3_TestDataStruct[TST_Index].TST_Name,TST_Index ));
    ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"************************ \n")); 

	TST_ATP_Error = SEPQA_DH_PKCS3(
							SEP_DH_Acceptance_PKCS3_TestDataStruct[TST_Index].TST_Generator,
							SEP_DH_Acceptance_PKCS3_TestDataStruct[TST_Index].TST_GeneratorSize,
							SEP_DH_Acceptance_PKCS3_TestDataStruct[TST_Index].TST_Prime,
							SEP_DH_Acceptance_PKCS3_TestDataStruct[TST_Index].TST_PrimeSize,
							SEP_DH_Acceptance_PKCS3_TestDataStruct[TST_Index].TST_L,
							FailureFunctionNameOut,
							FailureFunctionName_K_Size);
		
	TST_TestStatus = TST_ATP_CheckErrorReturn(TST_ATP_Error,"SEPQA_DH_PKCS3",FailureFunctionNameOut,TST_MasterTestName);                   

	if (TST_TestStatus != TESTPASS) 
		goto End;	
                                        
End:
    return TST_TestStatus;                          
}


/*****************************************************/
/*TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR********************/
/*--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR******************/
/*TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR********************/
/*--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR******************/
/*****************************************************/
/***************************
* Function Name:                                                           
* 	CRYS_Ext_ATP_DH_Acceptance_ANSI942 		
* 
* Inputs:
* 	None
*
* Outputs:
* 	CRYSError_t - Function error return		    					  		
*
* Description:	
*  This function Is a Acceptance test for Diffie-Hellman key agreement 
*  schemes according to ANSI9.42   
*  Prime sizes used (in bits) - 2048									
*  Generator sizes used (in bits) - 2048
*  Q sizes used (in bits) - 160
*  Derived Key sizes (in bits) - 256
*
* Algorithm:       
* 1. Call the SEPQA_DH_ANSI942 function to execute test
* 2. Verify function succeded according to the returned error code
*
**************************/
CRYSError_t CRYS_Ext_ATP_DH_Acceptance_ANSI942(void)
{
    int                  TST_Index = 0;
	int                  TST_KeyGetSecretKeyType,TST_SecretDataGenType;
    CRYSError_t          TST_TestStatus=0;
    char                 TST_MasterTestName[TST_FUNC_STRING_LEN] = "CRYS_Ext_ATP_DH_Acceptance_ANSI942";
	
    

    ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"********************* \n"));
    ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"** CRYS_Ext_ATP_DH_Acceptance_ANSI942 Tests ******* \n"));      
    ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"********************* \n \n")); 

	/****************/
    /***** Start of test ********/
    /****************/
    for (TST_SecretDataGenType = 0; TST_SecretDataGenType < TST_DH_SECRET_DATA_GEN_TYPES ;TST_SecretDataGenType++)
    { 
        for (TST_KeyGetSecretKeyType =0 ;TST_KeyGetSecretKeyType < TST_DH_ANSI924_DERIVATION_MODES ; TST_KeyGetSecretKeyType++) 
        {   
			/* according to standart ANSI942 doesn't work with prime size  = 512 bit */
            if (SEP_DH_Acceptance_ANSI942_TestDataStruct[TST_Index].TST_PrimeSize == 64)
                continue;
            
            ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"************************ \n")); 
            ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"  %s [test 2.%d] \n",SEP_DH_Acceptance_ANSI942_TestDataStruct[TST_Index].TST_Name,TST_Index ));
            if (TST_SecretDataGenType == TST_DH_NON_HYBRID_MODE)
                ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"  NON Hybrid secret data derivation \n"));                
            else
                ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"  Hybrid secret data derivation \n"));
            if (TST_KeyGetSecretKeyType == TST_DH_GET_SECRET_KEY_ASN1)
                ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"  ASN1 KeyDerivation SHA1 Func \n")); 
            else
                ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"  Concat Key Derivation SHA1 Func \n"));
            ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"************************ \n")); 

			TST_ATP_Error = SEPQA_DH_ANSI942(
				SEP_DH_Acceptance_ANSI942_TestDataStruct[TST_Index].TST_Generator,
				SEP_DH_Acceptance_ANSI942_TestDataStruct[TST_Index].TST_GeneratorSize,
				SEP_DH_Acceptance_ANSI942_TestDataStruct[TST_Index].TST_Prime,
				SEP_DH_Acceptance_ANSI942_TestDataStruct[TST_Index].TST_PrimeSize,
				SEP_DH_Acceptance_ANSI942_TestDataStruct[TST_Index].TST_Q, 
				(DxUint16_t)SEP_DH_Acceptance_ANSI942_TestDataStruct[TST_Index].TST_QSize,
				TST_SecretDataGenType,
				TST_KeyGetSecretKeyType,
				SEP_DH_Acceptance_ANSI942_TestDataStruct[TST_Index].TST_KeyLenInBits,
				FailureFunctionNameOut,
				FailureFunctionName_K_Size);

			TST_TestStatus = TST_ATP_CheckErrorReturn(TST_ATP_Error,"SEPQA_DH_ANSI942",FailureFunctionNameOut,TST_MasterTestName);                   

			if (TST_TestStatus != TESTPASS) 
				goto End;	
        }/*End of TST_KeyDerivationMode loop */ 
    }/*End of TST_SecretDataGenType loop*/
End:
    return TST_TestStatus;                          
}




